implementation module wstate


//	Clean Object I/O library, version 1.1


import	StdInt, StdList, StdTuple, StdFunc
import	oswindow
import	commondef, windowhandle, windowdefaccess, controldefaccess


wstateFatalError :: String String -> .x
wstateFatalError rule error
	= FatalError rule "wstate" error


/*	The WindowHandle` data type.
	This type is a subtype of the WindowHandle data type. The WindowHandle` data type 
	takes the projection of those fields of the (WindowHandle ls ps) data type that 
	do not depend on the type variables {ls,ps}.
*/
::	WindowHandle`
	=	{	whMode`				:: WindowMode					// The window mode (Modal or Modeless)
		,	whKind`				:: WindowKind					// The window kind (Window or Dialog)
		,	whTitle`			:: Title						// The window title
		,	whItemNrs`			:: [Int]						// The list of free system item numbers for all controls
		,	whKeyFocus`			:: KeyFocus						// The item that has the keyboard input focus
		,	whWindowInfo`		:: Maybe WindowInfo				// Additional information about the Window (Nothing for Dialogs)
		,	whItems`			:: [WElementHandle`]			// The window controls
		,	whShow`				:: Bool							// The visibility of the window (True iff visible)
		,	whSelect`			:: Bool							// The WindowSelect==Able (by default True)
		,	whAtts`				:: [WindowAttribute`]			// The window attributes
		,	whDefaultId`		:: Maybe Id						// The Id of the optional default button
		,	whCancelId`			:: Maybe Id						// The Id of the optional cancel  button
		,	whSize`				:: Size							// The exact size of the window
		}
::	WElementHandle`
	=	WItemHandle`			WItemHandle`
	|	WRecursiveHandle`		[WElementHandle`] WRecursiveKind
::	WRecursiveKind
	=	IsWListLSHandle
	|	IsWExtendLSHandle
	|	IsWChangeLSHandle
::	WItemHandle`
	=	{	wItemId`			:: Maybe Id						// If the control has a (ControlId id) attribute, then Just id; Nothing
		,	wItemNr`			:: Int							// The internal nr of this control  (generated from whIds)
		,	wItemKind`			:: ControlKind					// The sort of control
		,	wItemShow`			:: Bool							// The visibility of the control (True iff visible)
		,	wItemSelect`		:: Bool							// The ControlSelectState==Able  (by default True)
		,	wItemInfo`			:: WItemInfo`					// Additional information of the control
		,	wItemAtts`			:: [ControlAttribute`]			// The control attributes
		,	wItems`				:: [WElementHandle`]			// In case of	CompoundControl	: its control elements
																//				Otherwise		: []
		,	wItemPos`			:: !Point						// The exact position of the item
		,	wItemFixedPos`		:: Bool							// The layout of the item is either Fix or relative to a Fix item
		,	wItemSize`			:: Size							// The exact size of the item
		,	wItemPtr`			:: OSWindowPtr					// The ptr to the item (OSNoWindowPtr if no handle)
		}
::	WItemInfo`
	=	RadioInfo`				RadioInfo`						// In case of	RadioControl		: the radio items information
	|	CheckInfo`				CheckInfo`						// In case of	CheckControl		: the check items information
	|	PopUpInfo`				PopUpInfo`						// In case of	PopUpControl		: the pop up information
	|	SliderInfo`				SliderInfo`						// In case of	SliderControl		: the slider information
	|	TextInfo`				TextInfo						// In case of	TextControl			: the text information
	|	EditInfo`				EditInfo						// In case of	EditControl			: the edit text information
	|	ButtonInfo`				ButtonInfo						// In case of	ButtonControl		: the button information
	|	CustomButtonInfo`		CustomButtonInfo				// In case of	CustomButtonControl	: the custom button information
	|	CustomInfo`				CustomInfo						// In case of	CustomControl		: the custom information
	|	CompoundInfo`			CompoundInfo					// In case of	CompoundControl		: the compound control information
	|	NoWItemInfo`											// No additional information
::	RadioInfo`
	=	{	radioItems`			:: [RadioItemInfo`]				// The radio items and their exact position (initially zero)
		,	radioLayout`		:: RowsOrColumns				// The layout of the radio items
		,	radioIndex`			:: Int							// The currently selected radio item (1<=radioIndex<=length radioItems)
		}
::	RadioItemInfo`
	=	{	radioItem`			:: TextLine						// The text of the item
		,	radioItemPos`		:: !Point						// The exact position of the item
		,	radioItemSize`		:: Size							// The exact size of the item
		,	radioItemPtr`		:: OSWindowPtr					// The OSWindowPtr of the item
		}
::	CheckInfo`
	=	{	checkItems`			:: [CheckItemInfo`]				// The check items and their exact position (initially zero)
		,	checkLayout`		:: RowsOrColumns				// The layout of the check items
		}
::	CheckItemInfo`
	=	{	checkItem`			:: (TextLine,MarkState)			// The text and mark of the item
		,	checkItemPos`		:: !Point						// The exact position of the item
		,	checkItemSize`		:: Size							// The exact size of the item
		,	checkItemPtr`		:: OSWindowPtr					// The OSWindowPtr of the item
		}
::	PopUpInfo`
	=	{	popUpInfoItems`		:: [TextLine]					// The pop up items
		,	popUpInfoIndex`		:: Index						// The currently selected pop up item (1<=popUpInfoIndex<=length popUpInfoItems)
		}
::	SliderInfo`
	=	{	sliderInfoDir`		:: Direction					// The direction of the slider
		,	sliderInfoLength`	:: Length						// The length (in pixels) of the slider
		,	sliderInfoState`	:: SliderState					// The current slider state
		}
::	WindowAttribute`
	=	WindowId`			Id
	|	WindowPos`			ItemPos
	|	WindowIndex`		Int
	|	WindowSize`			Size
	|	WindowHMargin`		Int Int
	|	WindowVMargin`		Int Int
	|	WindowItemSpace`	Int Int
	|	WindowOk`			Id
	|	WindowCancel`		Id
	|	WindowHide`
	|	WindowClose`
	|	WindowInit`
	|	WindowSelectState`	SelectState
	|	WindowLook`			Look
	|	WindowViewDomain`	ViewDomain
	|	WindowOrigin`		Point
	|	WindowHScroll`		ScrollFunction
	|	WindowVScroll`		ScrollFunction
	|	WindowMinimumSize`	Size
	|	WindowResize`
	|	WindowActivate`
	|	WindowDeactivate`
	|	WindowMouse`		SelectState
	|	WindowKeyboard`		SelectState
	| 	WindowCursor`		CursorShape
::	ControlAttribute`
	=	ControlId`			Id
	|	ControlPos`			ItemPos
	|	ControlSize`		Size
	|	ControlMinimumSize`	Size
	|	ControlResize`		ControlResizeFunction
	|	ControlSelectState`	SelectState
	|	ControlHide`
	|	ControlFunction`
	|	ControlModsFunction`
	|	ControlMouse`		SelectState
	|	ControlKeyboard`	SelectState
	|	ControlItemSpace`	Int Int
	|	ControlHMargin`		Int Int
	|	ControlVMargin`		Int Int
	|	ControlLook`		Look
	|	ControlViewDomain`	ViewDomain
	|	ControlOrigin`		Point
	|	ControlHScroll`		ScrollFunction
	|	ControlVScroll`		ScrollFunction


retrieveWindowHandle` :: !u:(WindowStateHandle .ps) !*OSToolbox -> (!WindowHandle`,!u:WindowStateHandle .ps,!*OSToolbox)
retrieveWindowHandle` wsH=:{wshIds={wPtr},wshHandle=Just wlsH=:{wlsHandle}} tb
	# (wH`,wH,tb)	= getWindowHandle` wPtr wlsHandle tb
	= (wH`,{wsH & wshHandle=Just {wlsH & wlsHandle=wH}},tb)
retrieveWindowHandle` _ _
	= wstateFatalError "retrieveWindowHandle`" "unexpected window placeholder argument"

insertWindowHandle` :: !WindowHandle` !u:(WindowStateHandle .ps) -> u:WindowStateHandle .ps
insertWindowHandle` wH` wsH=:{wshHandle=Just wlsH=:{wlsHandle}}
	= {wsH & wshHandle=Just {wlsH & wlsHandle=setWindowHandle` wH` wlsHandle}}
insertWindowHandle` _ _
	= wstateFatalError "insertWindowHandle`" "unexpected window placeholder argument"

getWindowHandle` :: !OSWindowPtr !u:(WindowHandle .ls .ps) !*OSToolbox -> (!WindowHandle`,!u:WindowHandle .ls .ps,!*OSToolbox)
getWindowHandle` wPtr wH=:{	whMode
						  ,	whKind
						  ,	whTitle
						  ,	whItemNrs
						  ,	whKeyFocus
						  ,	whWindowInfo
						  ,	whItems=items
						  ,	whShow
						  ,	whSelect
						  ,	whAtts
						  ,	whDefaultId
						  ,	whCancelId
						  ,	whSize
						  } tb
	#! (items`,items,tb)	= getWElementHandles` wPtr items tb
	= (	{	whMode`			= whMode
		,	whKind`			= whKind
		,	whTitle`		= whTitle
		,	whItemNrs`		= whItemNrs
		,	whKeyFocus`		= whKeyFocus
		,	whWindowInfo`	= whWindowInfo
		,	whItems`		= items`
		,	whShow`			= whShow
		,	whSelect`		= whSelect
		,	whAtts`			= map getWAtt whAtts
		,	whDefaultId`	= whDefaultId
		,	whCancelId`		= whCancelId
		,	whSize`			= whSize
		}
	  ,	{wH & whItems=items}
	  ,	tb
	  )
where
	getWAtt :: !(WindowAttribute .ps) -> WindowAttribute`
	getWAtt (WindowId          id)			= WindowId`          id
	getWAtt (WindowPos         pos)			= WindowPos`         pos
	getWAtt (WindowIndex       index)		= WindowIndex`       index
	getWAtt (WindowSize        size)		= WindowSize`        size
	getWAtt (WindowHMargin     l r)			= WindowHMargin`     l r
	getWAtt (WindowVMargin     t b)			= WindowVMargin`     t b
	getWAtt (WindowItemSpace   h v)			= WindowItemSpace`   h v
	getWAtt (WindowOk          id)			= WindowOk`          id
	getWAtt (WindowCancel      id)			= WindowCancel`      id
	getWAtt  WindowHide						= WindowHide`
	getWAtt (WindowClose       _)			= WindowClose`
	getWAtt (WindowInit        _)			= WindowInit`
	getWAtt (WindowSelectState select)		= WindowSelectState` select
	getWAtt (WindowLook        look)		= WindowLook`        look
	getWAtt (WindowViewDomain  domain)		= WindowViewDomain`  domain
	getWAtt (WindowOrigin      origin)		= WindowOrigin`      origin
	getWAtt (WindowHScroll     f)			= WindowHScroll`     f
	getWAtt (WindowVScroll     f)			= WindowVScroll`     f
	getWAtt (WindowMinimumSize size)		= WindowMinimumSize` size
	getWAtt  WindowResize					= WindowResize`
	getWAtt (WindowActivate    _)			= WindowActivate`
	getWAtt (WindowDeactivate  _)			= WindowDeactivate`
	getWAtt (WindowMouse       _ select _)	= WindowMouse`       select
	getWAtt (WindowKeyboard    _ select _)	= WindowKeyboard`    select
	getWAtt (WindowCursor      shape)		= WindowCursor`      shape

getWElementHandles` :: !OSWindowPtr ![WElementHandle .ls .ps] !*OSToolbox -> (![WElementHandle`],![WElementHandle .ls .ps],!*OSToolbox)
getWElementHandles` wPtr [itemH:itemHs] tb
	#! (itemH`, itemH, tb)	= getWElementHandle`  wPtr itemH  tb
	#! (itemHs`,itemHs,tb)	= getWElementHandles` wPtr itemHs tb
	= ([itemH`:itemHs`],[itemH:itemHs],tb)
where
	getWElementHandle` :: !OSWindowPtr !(WElementHandle .ls .ps) !*OSToolbox -> (!WElementHandle`,!WElementHandle .ls .ps,!*OSToolbox)
	getWElementHandle` wPtr (WItemHandle itemH) tb
		#! (itemH`,itemH,tb)	= getWItemHandle` wPtr itemH tb
		= (WItemHandle` itemH`,WItemHandle itemH,tb)
	getWElementHandle` wPtr (WListLSHandle itemHs) tb
		#! (itemHs`,itemHs,tb)	= getWElementHandles` wPtr itemHs tb
		= (WRecursiveHandle` itemHs` IsWListLSHandle,WListLSHandle itemHs,tb)
	getWElementHandle` wPtr (WExtendLSHandle exH=:{wExtendItems=itemHs}) tb
		#! (itemHs`,itemHs,tb)	= getWElementHandles` wPtr itemHs tb
		= (WRecursiveHandle` itemHs` IsWExtendLSHandle,WExtendLSHandle {exH & wExtendItems=itemHs},tb)
	getWElementHandle` wPtr (WChangeLSHandle chH=:{wChangeItems=itemHs}) tb
		#! (itemHs`,itemHs,tb)	= getWElementHandles` wPtr itemHs tb
		= (WRecursiveHandle` itemHs` IsWChangeLSHandle,WChangeLSHandle {chH & wChangeItems=itemHs},tb)
getWElementHandles` _ _ tb
	= ([],[],tb)

getWItemHandle` :: !OSWindowPtr !(WItemHandle .ls .ps) !*OSToolbox -> (!WItemHandle`,!WItemHandle .ls .ps,!*OSToolbox)
getWItemHandle` wPtr itemH=:{	wItemId
							,	wItemNr
							,	wItemKind
							,	wItemShow
							,	wItemSelect
							,	wItemInfo
							,	wItemAtts
							,	wItems
							,	wItemPos
							,	wItemFixedPos
							,	wItemSize
							,	wItemPtr
							} tb
	#! (itemHs`,itemHs,tb)	= getWElementHandles` wPtr wItems tb
	#! (info`,info,tb)		= getWItemInfo` wPtr wItemPtr wItemInfo tb
	= (	{	wItemId`		= wItemId
		,	wItemNr`		= wItemNr
		,	wItemKind`		= wItemKind
		,	wItemShow`		= wItemShow
		,	wItemSelect`	= wItemSelect
		,	wItemInfo`		= info`
		,	wItemAtts`		= map getWItemAtt` wItemAtts
		,	wItems`			= itemHs`
		,	wItemPos`		= wItemPos
		,	wItemFixedPos`	= wItemFixedPos
		,	wItemSize`		= wItemSize
		,	wItemPtr`		= wItemPtr
		}
	  ,	{itemH & wItems=itemHs,wItemInfo=info}
	  ,	tb
	  )
where
	getWItemAtt` :: !(ControlAttribute .ps) -> ControlAttribute`
	getWItemAtt` (ControlId           id)			= ControlId`          id
	getWItemAtt` (ControlPos          pos)			= ControlPos`         pos
	getWItemAtt` (ControlSize         size)			= ControlSize`        size
	getWItemAtt` (ControlMinimumSize  size)			= ControlMinimumSize` size
	getWItemAtt` (ControlResize       f)			= ControlResize`      f
	getWItemAtt` (ControlSelectState  select)		= ControlSelectState` select
	getWItemAtt`  ControlHide						= ControlHide`
	getWItemAtt` (ControlFunction     _)			= ControlFunction`
	getWItemAtt` (ControlModsFunction _)			= ControlModsFunction`
	getWItemAtt` (ControlMouse        _ select _)	= ControlMouse`       select
	getWItemAtt` (ControlKeyboard     _ select _)	= ControlKeyboard`    select
	getWItemAtt` (ControlItemSpace    h v)			= ControlItemSpace`   h v
	getWItemAtt` (ControlHMargin      l r)			= ControlHMargin`     l r
	getWItemAtt` (ControlVMargin      t b)			= ControlVMargin`     t b
	getWItemAtt` (ControlLook         look)			= ControlLook`        look
	getWItemAtt` (ControlViewDomain   domain)		= ControlViewDomain`  domain
	getWItemAtt` (ControlOrigin       origin)		= ControlOrigin`      origin
	getWItemAtt` (ControlHScroll      f)			= ControlHScroll`     f
	getWItemAtt` (ControlVScroll      f)			= ControlVScroll`     f
	
	getWItemInfo` :: !OSWindowPtr !OSWindowPtr !(WItemInfo .ls .ps) !*OSToolbox -> !(WItemInfo`,!WItemInfo .ls .ps,!*OSToolbox)
	getWItemInfo` wPtr itemPtr info=:(RadioInfo {radioItems,radioLayout,radioIndex}) tb
		= (	RadioInfo` { radioItems`  = map getRadioInfo` radioItems
					   , radioLayout` = radioLayout
					   , radioIndex`  = radioIndex
					   }
		  ,	info
		  ,	tb
		  )
	where
		getRadioInfo` :: !(RadioItemInfo .ps) -> RadioItemInfo`
		getRadioInfo` {radioItem=(text,_),radioItemPos,radioItemSize,radioItemPtr}
			= {	radioItem`     = text
			  ,	radioItemPos`  = radioItemPos
			  ,	radioItemSize` = radioItemSize
			  ,	radioItemPtr`  = radioItemPtr
			  }
	getWItemInfo` wPtr itemPtr info=:(CheckInfo {checkItems,checkLayout}) tb
		= (	CheckInfo` { checkItems`  = map getCheckInfo` checkItems
					   , checkLayout` = checkLayout
					   }
		  ,	info
		  ,	tb
		  )
	where
		getCheckInfo` :: !(CheckItemInfo .ps) -> CheckItemInfo`
		getCheckInfo` {checkItem=(text,mark,_),checkItemPos,checkItemSize,checkItemPtr}
			= {	checkItem`     = (text,mark)
			  ,	checkItemPos`  = checkItemPos
			  ,	checkItemSize` = checkItemSize
			  ,	checkItemPtr`  = checkItemPtr
			  }
	getWItemInfo` wPtr itemPtr info=:(PopUpInfo {popUpInfoItems,popUpInfoIndex}) tb
		= (	PopUpInfo` { popUpInfoItems` = map fst popUpInfoItems
					   , popUpInfoIndex` = popUpInfoIndex
					   }
		  ,	info
		  ,	tb
		  )
	getWItemInfo` wPtr itemPtr info=:(SliderInfo {sliderInfoDir,sliderInfoLength,sliderInfoState}) tb
		= (	SliderInfo` { sliderInfoDir`    = sliderInfoDir
						, sliderInfoLength` = sliderInfoLength
						, sliderInfoState`  = sliderInfoState
						}
		  ,	info
		  ,	tb
		  )
	getWItemInfo` wPtr itemPtr info=:(TextInfo textInfo) tb
		= (TextInfo` textInfo,info,tb)
	getWItemInfo` wPtr itemPtr info=:(EditInfo editInfo) tb
		# (content,tb)	= OSgetEditControlText wPtr itemPtr tb
		#! editInfo		= {editInfo & editInfoText=content}
		= (EditInfo` editInfo,info,tb)
	getWItemInfo` wPtr itemPtr info=:(ButtonInfo buttonInfo) tb
		= (ButtonInfo` buttonInfo,info,tb)
	getWItemInfo` wPtr itemPtr info=:(CustomButtonInfo customButtonInfo) tb
		= (CustomButtonInfo` customButtonInfo,info,tb)
	getWItemInfo` wPtr itemPtr info=:(CustomInfo customInfo) tb
		= (CustomInfo` customInfo,info,tb)
	getWItemInfo` wPtr itemPtr info=:(CompoundInfo compoundInfo) tb
		= (CompoundInfo` compoundInfo,info,tb)
	getWItemInfo` wPtr itemPtr info=:(ReceiverInfo _) tb
		= (NoWItemInfo`,info,tb)
	getWItemInfo` wPtr itemPtr info=:NoWItemInfo tb
		= (NoWItemInfo`,info,tb)

setWindowHandle` :: !WindowHandle` !u:(WindowHandle .ls .ps) -> u:WindowHandle .ls .ps
setWindowHandle` wH`=:{whTitle`,whItemNrs`,whKeyFocus`,whWindowInfo`,whItems`,whShow`,whSelect`,whAtts`,whSize`} wH=:{whItems,whAtts}
	#! itemHs	= setWElementHandles` whItems` whItems
	#! atts		= setWAtts whAtts` whAtts
	= {	wH	& whTitle		= whTitle`
			, whItemNrs		= whItemNrs`
			, whKeyFocus	= whKeyFocus`
			, whWindowInfo	= whWindowInfo`
			, whItems		= itemHs
			, whShow		= whShow`
			, whSelect		= whSelect`
			, whAtts		= atts
			, whSize		= whSize`
	  }
where
	setWAtts :: ![WindowAttribute`] ![WindowAttribute .ps] -> [WindowAttribute .ps]
	setWAtts [att`:atts`] [att:atts]
		#! att	= setWAtt att` att
		#! atts	= setWAtts atts` atts
		= [att:atts]
	setWAtts [] []
		= []
	setWAtts _ _
		= wstateFatalError "setWindowHandle`" "incompatible number of WindowAttributes"
	
	setWAtt :: !WindowAttribute` !(WindowAttribute .ps) -> WindowAttribute .ps
	setWAtt (WindowId`          _)			att=:(WindowId           _)	= att
	setWAtt (WindowPos`         pos)		att=:(WindowPos          _)	= WindowPos         pos
	setWAtt (WindowIndex`       index)		att=:(WindowIndex        _)	= WindowIndex       index
	setWAtt (WindowSize`        size)		att=:(WindowSize         _)	= WindowSize        size
	setWAtt (WindowHMargin`     _ _)		att=:(WindowHMargin    _ _)	= att
	setWAtt (WindowVMargin`     _ _)		att=:(WindowVMargin    _ _)	= att
	setWAtt (WindowItemSpace`   _ _)		att=:(WindowItemSpace  _ _)	= att
	setWAtt (WindowOk`          okId)		att=:(WindowOk           _)	= WindowOk          okId
	setWAtt (WindowCancel`      cancelId)	att=:(WindowCancel       _)	= WindowCancel      cancelId
	setWAtt  WindowHide`					att=: WindowHide			= att
	setWAtt  WindowClose`					att=:(WindowClose        _)	= att
	setWAtt  WindowInit`					att=:(WindowInit         _)	= att
	setWAtt (WindowSelectState`	select)		att=:(WindowSelectState  _)	= WindowSelectState select
	setWAtt (WindowLook`        look)		att=:(WindowLook         _)	= WindowLook        look
	setWAtt (WindowViewDomain`  domain)		att=:(WindowViewDomain   _)	= WindowViewDomain  domain
	setWAtt (WindowOrigin`      origin)		att=:(WindowOrigin       _)	= WindowOrigin      origin
	setWAtt (WindowHScroll`     scroll)		att=:(WindowHScroll      _)	= WindowHScroll		scroll
	setWAtt (WindowVScroll`     scroll)		att=:(WindowVScroll      _)	= WindowVScroll     scroll
	setWAtt (WindowMinimumSize` _)			att=:(WindowMinimumSize  _)	= att
	setWAtt  WindowResize`					att=: WindowResize			= att
	setWAtt  WindowActivate`				att=:(WindowActivate     _)	= att
	setWAtt  WindowDeactivate`				att=:(WindowDeactivate   _)	= att
	setWAtt (WindowMouse`       select)		att=:(WindowMouse    s _ f)	= WindowMouse    s select f
	setWAtt (WindowKeyboard`    select)		att=:(WindowKeyboard s _ f)	= WindowKeyboard s select f
	setWAtt (WindowCursor`      cursor)		att=:(WindowCursor       _)	= WindowCursor      cursor
	setWAtt _ _
		= wstateFatalError "setWindowHandle`" "WindowAttributes do not match pairwise"
	
setWElementHandles` :: ![WElementHandle`] ![WElementHandle .ls .ps] -> [WElementHandle .ls .ps]
setWElementHandles` [itemH`:itemHs`] [itemH:itemHs]
	#! itemH	= setWElement`  itemH`  itemH
	#! itemHs	= setWElementHandles` itemHs` itemHs
	= [itemH:itemHs]
where
	setWElement` :: !WElementHandle` !(WElementHandle .ls .ps) -> WElementHandle .ls .ps
	setWElement` (WItemHandle` itemH`) (WItemHandle itemH)
		#! itemH	= setWItemHandle` itemH` itemH
		=  WItemHandle itemH
	setWElement` (WRecursiveHandle` itemHs` IsWListLSHandle) (WListLSHandle itemHs)
		#! itemHs	= setWElementHandles` itemHs` itemHs
		=  WListLSHandle itemHs
	setWElement` (WRecursiveHandle` itemHs` IsWExtendLSHandle) (WExtendLSHandle exH=:{wExtendItems=itemHs})
		#! itemHs	= setWElementHandles` itemHs` itemHs
		=  WExtendLSHandle {exH & wExtendItems=itemHs}
	setWElement` (WRecursiveHandle` itemHs` IsWChangeLSHandle) (WChangeLSHandle chH=:{wChangeItems=itemHs})
		#! itemHs	= setWElementHandles` itemHs` itemHs
		=  WChangeLSHandle {chH & wChangeItems=itemHs}
	setWElement` _ _
		= wstateFatalError "setWElementHandles`" "WElementHandles do not match pairwise"
setWElementHandles` [] []
	= []
setWElementHandles` _ _
	= wstateFatalError "setWElementHandles`" "incompatible number of WElementHandles"

setWItemHandle` :: !WItemHandle` !(WItemHandle .ls .ps) -> WItemHandle .ls .ps
setWItemHandle` itemH`=:{	wItemNr`
						,	wItemShow`
						,	wItemSelect`
						,	wItemInfo`
						,	wItemAtts`	= atts`
						,	wItems`		= itemHs`
						,	wItemPos`
						,	wItemFixedPos`
						,	wItemSize`
						}
				itemH =:{	wItemInfo	= info
						,	wItemAtts	= atts
						,	wItems		= itemHs
						}
	#! info1	= setWItemInfo` wItemInfo` info
	   atts1	= setWItemAtts` atts` atts
	   itemHs1	= setWElementHandles` itemHs` itemHs
	= {	itemH	& wItemNr		= wItemNr`
				, wItemShow		= wItemShow`
				, wItemSelect	= wItemSelect`
				, wItemInfo		= info1
				, wItemAtts		= atts1
				, wItems		= itemHs1
				, wItemPos		= wItemPos`
				, wItemFixedPos	= wItemFixedPos`
				, wItemSize		= wItemSize`
	  }
where
	setWItemAtts` :: ![ControlAttribute`] ![ControlAttribute .ps] -> [ControlAttribute .ps]
	setWItemAtts` [att`:atts`] [att:atts]
		#! att	= setWItemAtt` att` att
		#! atts	= setWItemAtts` atts` atts
		= [att:atts]
	setWItemAtts` [] []
		= []
	setWItemAtts` _ _
		= wstateFatalError "setWItemHandle`" "incompatible number of ControlAttributes"
	
	setWItemAtt` :: !ControlAttribute` !(ControlAttribute .ps) -> ControlAttribute .ps
	setWItemAtt` (ControlId`           _)		att=:(ControlId           _)	= att
	setWItemAtt` (ControlPos`          pos)		att=:(ControlPos          _)	= ControlPos  pos
	setWItemAtt` (ControlSize`         size)	att=:(ControlSize         _)	= ControlSize size
	setWItemAtt` (ControlMinimumSize`  _)		att=:(ControlMinimumSize  _)	= att
	setWItemAtt` (ControlResize`       f)		att=:(ControlResize       _)	= ControlResize f
	setWItemAtt` (ControlSelectState`  select)	att=:(ControlSelectState  _)	= ControlSelectState select
	setWItemAtt`  ControlHide`					att=: ControlHide				= att
	setWItemAtt`  ControlFunction`				att=:(ControlFunction     _)	= att
	setWItemAtt`  ControlModsFunction`			att=:(ControlModsFunction _)	= att
	setWItemAtt` (ControlMouse`        select)	att=:(ControlMouse    s _ f)	= ControlMouse    s select f
	setWItemAtt` (ControlKeyboard`     select)	att=:(ControlKeyboard s _ f)	= ControlKeyboard s select f
	setWItemAtt` (ControlItemSpace`    _ _)		att=:(ControlItemSpace  _ _)	= att
	setWItemAtt` (ControlHMargin`      _ _)		att=:(ControlHMargin    _ _)	= att
	setWItemAtt` (ControlVMargin`      _ _)		att=:(ControlVMargin    _ _)	= att
	setWItemAtt` (ControlLook`         look)	att=:(ControlLook         _)	= ControlLook       look
	setWItemAtt` (ControlViewDomain`   domain)	att=:(ControlViewDomain   _)	= ControlViewDomain domain
	setWItemAtt` (ControlOrigin`       origin)	att=:(ControlOrigin       _)	= ControlOrigin     origin
	setWItemAtt` (ControlHScroll`      scroll)	att=:(ControlHScroll      _)	= ControlHScroll    scroll
	setWItemAtt` (ControlVScroll`      scroll)	att=:(ControlVScroll      _)	= ControlVScroll    scroll
	setWItemAtt` att` att
		= wstateFatalError "setWItemHandle`" "ControlAttributes do not match pairwise"
	
	setWItemInfo` :: !WItemInfo` !(WItemInfo .ls .ps) -> WItemInfo .ls .ps
	setWItemInfo` (RadioInfo` {radioItems`,radioIndex`}) (RadioInfo radio=:{radioItems,radioIndex})
		= RadioInfo {radio & radioItems=setRadioInfos radioItems` radioItems,radioIndex=radioIndex`}
	where
		setRadioInfos :: ![RadioItemInfo`] ![RadioItemInfo .ps] -> [RadioItemInfo .ps]
		setRadioInfos [info`:infos`] [info:infos]
			= [setRadioInfo info` info:setRadioInfos infos` infos]
		where
			setRadioInfo :: !RadioItemInfo` !(RadioItemInfo .ps) -> RadioItemInfo .ps
			setRadioInfo {radioItem`,radioItemPos`,radioItemSize`} info=:{radioItem=(_,f)}
				= {info & radioItem=(radioItem`,f),radioItemPos=radioItemPos`,radioItemSize=radioItemSize`}
		setRadioInfos [] []
			= []
		setRadioInfos _ _
			= wstateFatalError "setWindowHandle`" "incompatible RadioInfo"
	setWItemInfo` (CheckInfo` {checkItems`}) (CheckInfo check=:{checkItems})
		= CheckInfo {check & checkItems=setCheckInfos checkItems` checkItems}
	where
		setCheckInfos :: ![CheckItemInfo`] ![CheckItemInfo .ps] -> [CheckItemInfo .ps]
		setCheckInfos [info`:infos`] [info:infos]
			= [setCheckInfo info` info:setCheckInfos infos` infos]
		where
			setCheckInfo :: !CheckItemInfo` !(CheckItemInfo .ps) -> CheckItemInfo .ps
			setCheckInfo {checkItem`=(text,mark),checkItemPos`,checkItemSize`} info=:{checkItem=(_,_,f)}
				= {info & checkItem=(text,mark,f),checkItemPos=checkItemPos`,checkItemSize=checkItemSize`}
		setCheckInfos [] []
			= []
		setCheckInfos _ _
			= wstateFatalError "setWindowHandle`" "incompatible CheckInfo"
	setWItemInfo` (PopUpInfo` {popUpInfoItems`=texts`,popUpInfoIndex`=i}) (PopUpInfo popup=:{popUpInfoItems=items})
		= PopUpInfo {popup & popUpInfoItems=setpopuptexts texts` items,popUpInfoIndex=i}
	where
		setpopuptexts :: ![TextLine] ![PopUpControlItem .ps] -> [PopUpControlItem .ps]
		setpopuptexts [text:texts] [(_,f):items]
			= [(text,f):setpopuptexts texts items]
		setpopuptexts [] []
			= []
		setpopuptexts _ _
			= wstateFatalError "setWindowHandle`" "incompatible PopUpInfo"
	setWItemInfo` (SliderInfo` {sliderInfoDir`=dir,sliderInfoLength`=length,sliderInfoState`=state}) (SliderInfo slider)
		= SliderInfo {slider & sliderInfoDir=dir,sliderInfoLength=length,sliderInfoState=state}
	setWItemInfo` (TextInfo` info) (TextInfo _)
		= TextInfo info
	setWItemInfo` (EditInfo` info) (EditInfo _)
		= EditInfo info
	setWItemInfo` (ButtonInfo` info) (ButtonInfo _)
		= ButtonInfo info
	setWItemInfo` (CustomButtonInfo` info) (CustomButtonInfo _)
		= CustomButtonInfo info
	setWItemInfo` (CustomInfo` info) (CustomInfo _)
		= CustomInfo info
	setWItemInfo` (CompoundInfo` info) (CompoundInfo _)
		= CompoundInfo info
	setWItemInfo` NoWItemInfo` info
		= info
	setWItemInfo` _ _
		= wstateFatalError "setWindowHandle`" "incompatible WItemInfo"
